/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.tree;

import com.jrockit.mc.console.ui.actions.MBeanAutomaticRefreshAction;
import com.jrockit.mc.console.ui.mbeanbrowser.MBeanBrowserPlugin;
import com.jrockit.mc.console.ui.mbeanbrowser.messages.internal.Messages;
import com.jrockit.mc.console.ui.mbeanbrowser.tree.AddMBeanAction;
import com.jrockit.mc.console.ui.mbeanbrowser.tree.ObjectNameProvider;
import com.jrockit.mc.console.ui.mbeanbrowser.tree.UnregisterMBeanAction;
import com.jrockit.mc.core.ITreeNode;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import com.jrockit.mc.rjmx.ui.internal.MBeanPropertiesOrderer;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeLabelProvider;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeSorter;
import com.jrockit.mc.rjmx.ui.internal.TreeNodeBuilder;
import com.jrockit.mc.rjmx.ui.internal.TreeNodeFilter;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.misc.IRefreshable;
import com.jrockit.mc.ui.misc.MCLayoutFactory;
import com.jrockit.mc.ui.misc.TreeStructureContentProvider;
import com.jrockit.mc.ui.sections.ViewerSectionPart;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class MBeanTreeSectionPart
extends ViewerSectionPart
implements MBeanPropertiesOrderer.IMBeanPropertiesOrderChangedListener {
    public static final String MBEANBROWSER_MBEAN_TREE_NAME = "mbeanbrowser.MBeanTree";
    IRefreshable viewerRefresher = new IRefreshable(){

        public boolean refresh() {
            try {
                final ITreeNode[] nodes = MBeanTreeSectionPart.this.buildTreeModel();
                DisplayToolkit.safeAsyncExec((Widget)MBeanTreeSectionPart.this.getTreeViewer().getControl(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TreeItem newTopItem;
                        Object[] expandedElements = MBeanTreeSectionPart.this.getTreeViewer().getExpandedElements();
                        TreeItem topItem = MBeanTreeSectionPart.this.getTreeViewer().getTree().getTopItem();
                        Object topObject = topItem != null ? topItem.getData() : null;
                        MBeanTreeSectionPart.this.getTreeViewer().getControl().setRedraw(false);
                        MBeanTreeSectionPart.this.getTreeViewer().setInput((Object)nodes);
                        MBeanTreeSectionPart.this.getTreeViewer().setExpandedElements(expandedElements);
                        if (topObject != null && (newTopItem = this.findItem(topObject, MBeanTreeSectionPart.this.getTreeViewer().getTree().getItems())) != null) {
                            MBeanTreeSectionPart.this.getTreeViewer().getTree().setTopItem(newTopItem);
                        }
                        MBeanTreeSectionPart.this.getTreeViewer().getControl().setRedraw(true);
                        MBeanTreeSectionPart.this.getTreeViewer().getControl().redraw();
                    }

                    private TreeItem findItem(Object object, TreeItem[] items) {
                        if (items == null) {
                            return null;
                        }
                        TreeItem[] treeItemArray = items;
                        int n = items.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem item = treeItemArray[n2];
                            if (object.equals(item.getData())) {
                                return item;
                            }
                            TreeItem childItem = this.findItem(object, item.getItems());
                            if (childItem != null) {
                                return childItem;
                            }
                            ++n2;
                        }
                        return null;
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return true;
        }
    };

    public MBeanTreeSectionPart(Composite parent, FormToolkit toolkit, int style, String sectionIdentifier) {
        super(parent, toolkit, style, sectionIdentifier);
    }

    protected void initializeSection(Section section) {
        section.setText(Messages.MBeanTreeSectionPart_MBEAN_TREE_TITLE_TEXT);
        if (UIPlugin.getDefault().getAccessibilityMode()) {
            section.setDescription(section.getText());
        }
    }

    public void initializePart() {
        super.initializePart();
        if (!this.getConnectionHandle().isConnected()) {
            return;
        }
        ITreeNode[] nodes = this.buildTreeModel();
        this.getTreeViewer().setInput((Object)nodes);
        this.getTreeViewer().refresh((Object)true, true);
        this.addAddMBeanAction();
        this.addRefreshAction();
        this.setupDoubleClickListener();
        this.selectDefaultBean(nodes);
    }

    public void dispose() {
        MBeanPropertiesOrderer.removePropertiesOrderChangedListener((MBeanPropertiesOrderer.IMBeanPropertiesOrderChangedListener)this);
        super.dispose();
    }

    private void selectDefaultBean(ITreeNode[] nodes) {
        try {
            ObjectName bean = ObjectName.getInstance("java.lang", "type", "OperatingSystem");
            ArrayList<ITreeNode> search = new ArrayList<ITreeNode>();
            search.addAll(Arrays.asList(nodes));
            while (!search.isEmpty()) {
                ITreeNode node = (ITreeNode)search.remove(0);
                if (node.getUserData() instanceof MBeanPropertiesOrderer.PropertyWithMBean && bean.equals(((MBeanPropertiesOrderer.PropertyWithMBean)node.getUserData()).getBean())) {
                    this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)node), true);
                    return;
                }
                ITreeNode[] children = node.getChildren();
                if (children == null) continue;
                search.addAll(Arrays.asList(children));
            }
            MBeanBrowserPlugin.getDefault().getLogger().warning("Couldn't find " + bean + " in MBean tree");
        }
        catch (Exception e) {
            e.printStackTrace();
            MBeanBrowserPlugin.getDefault().getLogger().warning("Failed to select OperatingSystem bean: " + e);
        }
    }

    private void addAddMBeanAction() {
        MBeanServerConnection connection = (MBeanServerConnection)this.getConnectionHandle().getServiceOrNull(MBeanServerConnection.class);
        AddMBeanAction addMBeanAction = new AddMBeanAction(connection, this.getConnectionHandle().getServerDescriptor().getGUID());
        this.getMCToolBarManager().add((IAction)addMBeanAction);
        addMBeanAction.setEnabled(connection != null);
    }

    private void addRefreshAction() {
        this.getMCToolBarManager().add((IAction)new MBeanAutomaticRefreshAction(this.getConnectionHandle(), this.viewerRefresher));
    }

    protected Composite createViewerClient(IManagedForm form, FormToolkit formToolkit, Composite section) {
        Composite container = formToolkit.createComposite(section, 0);
        container.setLayout(MCLayoutFactory.createPaintBordersMarginFreeFormPageLayout((int)1));
        Composite filterComposite = formToolkit.createComposite(container);
        formToolkit.paintBordersFor(filterComposite);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        filterComposite.setLayout((Layout)layout);
        Label filterLabel = formToolkit.createLabel(filterComposite, Messages.MBeanTreeSectionPart_MBEAN_TREE_FILTER_TEXT);
        filterLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        Text filterText = formToolkit.createText(filterComposite, "");
        filterText.setLayoutData((Object)new GridData(4, 4, true, false));
        filterText.setToolTipText(Messages.MBeanTreeSectionPart_MBEAN_TREE_FILTER_TOOLTIP_TEXT);
        filterComposite.setLayoutData(MCLayoutFactory.createFormPageLayoutData((int)-1, (int)-1, (boolean)true, (boolean)false));
        this.m_viewer = this.createViewer(container);
        this.m_viewer.getControl().setLayoutData(MCLayoutFactory.createFormPageLayoutData((int)-1, (int)-1, (boolean)true, (boolean)true));
        TreeNodeFilter.install((TreeViewer)this.getTreeViewer(), (Text)filterText, (boolean)false);
        return container;
    }

    protected TreeViewer createViewer(Composite parent) {
        Tree tree = this.getFormToolkit().createTree(parent, 0);
        tree.setData("name", (Object)MBEANBROWSER_MBEAN_TREE_NAME);
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        TreeViewer viewer = new TreeViewer(tree);
        viewer.setUseHashlookup(true);
        viewer.setContentProvider((IContentProvider)new TreeStructureContentProvider());
        viewer.setSorter((ViewerSorter)new MBeanTreeSorter());
        viewer.setLabelProvider((IBaseLabelProvider)new MBeanTreeLabelProvider(null));
        MBeanPropertiesOrderer.addPropertiesOrderChangedListener((MBeanPropertiesOrderer.IMBeanPropertiesOrderChangedListener)this);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        this.getMenuManager().add((IAction)new UnregisterMBeanAction(this.getConnectionHandle(), viewer));
        return viewer;
    }

    protected void setupSelectionListeners() {
        this.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MBeanTreeSectionPart.this.getManagedForm().fireSelectionChanged((IFormPart)MBeanTreeSectionPart.this, new ObjectNameProvider(event.getSelectionProvider()).getSelection());
            }
        });
    }

    private void setupDoubleClickListener() {
        this.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ITreeNode elementNode = (ITreeNode)selection.getFirstElement();
                if (elementNode.getAdapter(ObjectName.class) == null) {
                    MBeanTreeSectionPart.this.getTreeViewer().setExpandedState((Object)elementNode, !MBeanTreeSectionPart.this.getTreeViewer().getExpandedState((Object)elementNode));
                }
            }
        });
    }

    private TreeViewer getTreeViewer() {
        return (TreeViewer)this.getViewer();
    }

    private IConnectionHandle getConnectionHandle() {
        return (IConnectionHandle)this.getManagedForm().getInput();
    }

    public void propertiesOrderChanged(PropertyChangeEvent e) {
        if (!e.getProperty().equals("console.ui.mbeanbrowser.showCompressedPaths")) {
            this.viewerRefresher.refresh();
        }
    }

    public ITreeNode[] buildTreeModel() {
        try {
            Set ons = ((IMBeanHelperService)this.getConnectionHandle().getServiceOrThrow(IMBeanHelperService.class)).getMBeanNames();
            TreeNodeBuilder root = new TreeNodeBuilder();
            for (ObjectName bean : ons) {
                MBeanPropertiesOrderer.Property[] properties;
                TreeNodeBuilder node = root.getUniqueChild((Object)bean.getDomain());
                MBeanPropertiesOrderer.Property[] propertyArray = properties = MBeanPropertiesOrderer.getOrderedProperties((ObjectName)bean);
                int n = properties.length;
                int n2 = 0;
                while (n2 < n) {
                    MBeanPropertiesOrderer.Property p = propertyArray[n2];
                    node = node.get((Object)p.getStringRepresentation());
                    if (p instanceof MBeanPropertiesOrderer.PropertyWithMBean || node.getValue() == null) {
                        node.setValue((Object)p);
                    }
                    ++n2;
                }
            }
            return root.getChildren(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

