/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.model.fields;

import com.jrockit.mc.common.parsing.Tokenizer;
import com.jrockit.mc.ui.model.fields.Messages;
import com.jrockit.mc.ui.model.fields.NumberField;
import com.jrockit.mc.ui.model.fields.TimeSpanField;
import com.jrockit.mc.ui.model.fields.TimespanParser;
import java.text.MessageFormat;
import java.text.ParseException;

public class TicksFields
extends NumberField {
    private final TimeSpanField TIME_SPAN_FIELD = new TimeSpanField(0);
    private final NumberField NUMBER_FIELD = new NumberField(0);
    private double m_tickPerSecond = Double.NaN;

    public TicksFields(int id) {
        super(id);
    }

    @Override
    public String formatObject(Object object) {
        if (object instanceof Number) {
            if (this.m_tickPerSecond == Double.NEGATIVE_INFINITY || Double.isNaN(this.m_tickPerSecond)) {
                return MessageFormat.format(Messages.TicksFields_TICKS_UNIT_X_TEXT, object);
            }
            double d = 1000.0 * ((Number)object).doubleValue() / this.m_tickPerSecond;
            return this.TIME_SPAN_FIELD.formatObject(d);
        }
        return TicksFields.defaultFormat(null);
    }

    @Override
    public String formatForClipboard(Object object) {
        if (object instanceof Number) {
            if (this.m_tickPerSecond == Double.NEGATIVE_INFINITY || Double.isNaN(this.m_tickPerSecond)) {
                return this.NUMBER_FIELD.formatForClipboard(object);
            }
            double d = 1000.0 * ((Number)object).doubleValue() / this.m_tickPerSecond;
            return this.TIME_SPAN_FIELD.formatForClipboard(d);
        }
        return TicksFields.defaultFormat(null);
    }

    public void setTickPerSecond(double ticksPerSecond) {
        this.m_tickPerSecond = ticksPerSecond;
    }

    public double getTicksPerSecond() {
        return this.m_tickPerSecond;
    }

    @Override
    public Object parse(Tokenizer tokenizer) throws ParseException {
        Long n = TimespanParser.parse(tokenizer);
        if (n != null && this.m_tickPerSecond != Double.NEGATIVE_INFINITY && !Double.isNaN(this.m_tickPerSecond)) {
            return ((Number)n).doubleValue() * this.m_tickPerSecond / 1.0E9;
        }
        return null;
    }
}

