/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.wizards;

import com.jrockit.mc.flightrecorder.controlpanel.ui.FlightRecorderProvider;
import com.jrockit.mc.flightrecorder.controlpanel.ui.jobs.StartRecordingJob;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.RecordingWizard;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.RecordingWizardModel;
import com.jrockit.mc.rjmx.services.flr.IEventSettingsHolder;
import com.jrockit.mc.ui.misc.DialogToolkit;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class StartRecordingWizard
extends RecordingWizard {
    private final FlightRecorderProvider recorder;

    public StartRecordingWizard(RecordingWizardModel model, FlightRecorderProvider recorder) {
        super(model);
        this.recorder = recorder;
    }

    public boolean performFinish() {
        this.startRecording(this.getModel());
        return true;
    }

    private void startRecording(RecordingWizardModel wizardModel) {
        try {
            Map<String, Object> recordingOptions = wizardModel.buildOptions();
            StartRecordingJob sr = new StartRecordingJob(this.recorder, wizardModel.getName(), recordingOptions, (IEventSettingsHolder)wizardModel.getAndSaveActiveConfiguration(), wizardModel.getPath());
            sr.schedule();
        }
        catch (IllegalArgumentException e) {
            DialogToolkit.showExceptionDialogAsync((Display)Display.getDefault(), (String)Messages.START_FLIGHT_RECORDING_PROBLEM_TITLE, (String)NLS.bind((String)Messages.START_FLIGHT_RECORDING_PROBLEM_TEXT, (Object)e.getLocalizedMessage()), (Throwable)e);
        }
    }
}

